// trees.inc

                  
#declare leaf_size=1/12; // 7 -40
#declare foliage_leaf=
isosurface {
 function { 
 f_sphere(x, y, z, 1)
 -f_noise3d(x/leaf_size, y/leaf_size, z/leaf_size)*1.5
 -f_noise3d(x*2, y* 2, z* 4)*1
 -f_noise3d(x*2, y* 1, z* 2)*1
 -f_noise3d(x*1, y* .5, z* 1)*1.5
 -f_noise3d(x*.5, y* .25, z*.5)*1.5
  }
 open
 contained_by { 
 // box {-4,4}
 // sphere { 0,1.225 }
  sphere { 0,5 }
 }
}
#declare foliage_form=
isosurface {
 function { 
 f_sphere(x, y, z, 1)
 // -f_noise3d(x/leaf_size, y/leaf_size, z/leaf_size)*1.5
 -f_noise3d(x*2, y* 2, z* 4)*1
 -f_noise3d(x*2, y* 1, z* 2)*1
 -f_noise3d(x*1, y* .5, z* 1)*1.5
 -f_noise3d(x*.5, y* .25, z*.5)*1.5
  }
 open
 contained_by { 
 // box {-4,4}
 // sphere { 0,1.225 }
  sphere { 0,5 }
 }
}

#declare foliage=
difference {
 object { foliage_leaf }
 object { foliage_form scale 1.12 }  // 1..1.3 density
}

#declare twigs=
object { foliage_form 
texture {
pigment {
crackle
turbulence 0.0
octaves 1
color_map {
[ 0.0 color rgbt <0.4,0.4,0.3,0> ]
[ 0.2 color rgbt <0,0,0,1> ]
} // map
scale <1,.5,1>*2
} // piment
} // texture 
finish { ambient 0.0 }
} // object

#declare bush=
union {
 union { 
  object { twigs scale 1.5 rotate 10*y  no_shadow }
  object { foliage scale 1.590  } // hidden layer for casting shadow
  object { foliage scale 1.600 no_shadow }
  scale 0.25 
 } 
 cone { <0,0,0>,0.2,<0,2,0>,0.1 translate -3.2*y
 texture { pigment { color rgb <0.8,0.8,0.6 > }}
 normal { bumps 1 scale <0.01,0.09,0.01> } 
 }
 scale <1.0, 1.7 ,1.0>
 translate <0.0,4.7,0.0>
}

#declare bushes=
union {
object { bush scale <0.7,1.5,0.7> translate <-07,0,ds-5> rotate 20*x 
texture { pigment { color rgb <0.1,0.9,0.1 > }} // spring
}
object { bush scale 1.2 translate <-03,0,ds> rotate 20*x 
texture { pigment { color rgb <0.1,0.9,0.1 > }} // spring
}
//object { bush scale 0.8 translate < 00,0,ds> rotate 00*x 
//texture { pigment { color rgb <0.2,0.9,0.0 > }} // summer
//}
object { bush scale 1.0 translate < 03,0,ds> rotate 10*x 
texture { pigment { color rgb <0.5,0.6,0.0 > }} // autumn
}
finish { ambient 0.7 }
}

object { bushes }
object { bushes translate <30,0,100> }

